/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.CrosshairMessageOverlay;
import xaero.map.mods.SupportMods;
import xaero.map.resource.ShaderResourceReloadListener;

public class ModEvents {
    private boolean listenToTextureStitch;

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_() != TextureAtlas.f_118259_) {
            return;
        }
        boolean shouldListenToStitch = this.listenToTextureStitch;
        this.listenToTextureStitch = true;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (shouldListenToStitch) {
                mapProcessor.getMapWriter().requestCachedColoursClear();
                mapProcessor.getBlockStateShortShapeCache().reset();
            }
        }
        if (shouldListenToStitch) {
            if (SupportMods.minimap()) {
                WorldMap.waypointSymbolCreator.resetChars();
            }
            if (WorldMap.settings != null) {
                WorldMap.settings.updateRegionCacheHashCode();
            }
        }
    }

    @SubscribeEvent
    public void handleRegisterClientResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ShaderResourceReloadListener());
    }

    @SubscribeEvent
    public void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "xaero_wm_crosshair_message", (IGuiOverlay)new CrosshairMessageOverlay());
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        WorldMap.controlsRegister = new ControlsRegister();
        WorldMap.controlsRegister.register(event);
    }
}

