/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.optifine.Config;
import net.optifine.shaders.IShaderPack;
import net.optifine.util.StrUtils;

public class ShaderPackZip
implements IShaderPack {
    protected File packFile;
    protected ZipFile packZipFile;
    protected String baseFolder;

    public ShaderPackZip(String name, File file) {
        this.packFile = file;
        this.packZipFile = null;
        this.baseFolder = "";
    }

    public void close() {
        if (this.packZipFile == null) {
            return;
        }
        try {
            this.packZipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.packZipFile = null;
    }

    public InputStream getResourceAsStream(String resName) {
        try {
            ZipEntry entry;
            String name;
            if (this.packZipFile == null) {
                this.packZipFile = new ZipFile(this.packFile);
                this.baseFolder = this.detectBaseFolder(this.packZipFile);
            }
            if ((name = StrUtils.removePrefix((String)resName, (String)"/")).contains("..")) {
                name = this.resolveRelative(name);
            }
            if ((entry = this.packZipFile.getEntry(this.baseFolder + name)) == null) {
                return null;
            }
            return this.packZipFile.getInputStream(entry);
        }
        catch (Exception excp) {
            return null;
        }
    }

    private String resolveRelative(String name) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String[] parts = Config.tokenize((String)name, (String)"/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.equals("..")) {
                if (stack.isEmpty()) {
                    return "";
                }
                stack.removeLast();
                continue;
            }
            stack.add(part);
        }
        String path = Joiner.on((char)'/').join(stack);
        return path;
    }

    private String detectBaseFolder(ZipFile zip) {
        ZipEntry entryShaders = zip.getEntry("shaders/");
        if (entryShaders != null && entryShaders.isDirectory()) {
            return "";
        }
        Pattern patternFolderShaders = Pattern.compile("([^/]+/)shaders/");
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            String base;
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            Matcher matcher = patternFolderShaders.matcher(name);
            if (!matcher.matches() || (base = matcher.group(1)) == null) continue;
            if (base.equals("shaders/")) {
                return "";
            }
            return base;
        }
        return "";
    }

    public boolean hasDirectory(String resName) {
        try {
            String name;
            ZipEntry entry;
            if (this.packZipFile == null) {
                this.packZipFile = new ZipFile(this.packFile);
                this.baseFolder = this.detectBaseFolder(this.packZipFile);
            }
            return (entry = this.packZipFile.getEntry(this.baseFolder + (name = StrUtils.removePrefix((String)resName, (String)"/")))) != null;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public String getName() {
        return this.packFile.getName();
    }
}

