/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
public final class VerticalSlopedStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return switch (blockType) {
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalSlopedStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleHalfSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDividedSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> VerticalSlopedStairsSkipPredicate.testAgainstInnerCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstThreewayCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstInnerThreewayCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleThreewayCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> VerticalSlopedStairsSkipPredicate.testAgainstDividedSlab(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> VerticalSlopedStairsSkipPredicate.testAgainstDividedPanelHor(dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstDoublePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> VerticalSlopedStairsSkipPredicate.testAgainstDividedPanelVert(dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstVerticalDoubleStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> VerticalSlopedStairsSkipPredicate.testAgainstDividedStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> VerticalSlopedStairsSkipPredicate.testAgainstStackedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatStackedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> VerticalSlopedStairsSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return true;
        }
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return true;
        }
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfSlope(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE})
    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE})})
    private static boolean testAgainstSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        ISlopeBlock block = (ISlopeBlock)adjState.m_60734_();
        Direction adjDir = block.getFacing(adjState);
        SlopeType adjType = block.getSlopeType(adjState);
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE, partTargets={BlockType.FRAMED_SLOPE})
    private static boolean testAgainstDoubleSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlope(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlope(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE})
    private static boolean testAgainstInnerCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_CORNER, partTargets={BlockType.FRAMED_INNER_CORNER_SLOPE, BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstDoubleCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstInnerCorner(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_THREEWAY_CORNER, BlockType.FRAMED_PRISM_CORNER})
    private static boolean testAgainstThreewayCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_INNER_PRISM_CORNER})
    private static boolean testAgainstInnerThreewayCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalSlopedStairsSkipPredicate.getTriDir(dir, rot, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_THREEWAY_CORNER, partTargets={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_THREEWAY_CORNER}), @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PRISM_CORNER, partTargets={BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_PRISM_CORNER})})
    private static boolean testAgainstDoubleThreewayCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstInnerThreewayCorner(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstThreewayCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PANEL, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstDoublePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstStairs(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_STAIRS, BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstVerticalStairs(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXTENDED_SLOPE_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_PANEL, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstStackedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalSlopedStairsSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstFlatStackedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalSlopedStairsSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || VerticalSlopedStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    public static TriangleDir getTriDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == dir.m_122424_()) {
            return TriangleDir.fromDirections(rot.getOpposite().withFacing(dir), rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir));
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == rot.withFacing(dir) || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

