/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
public final class FlatInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStackedSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStackedCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStackedInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDividedSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDividedPanelHor(dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalDividedStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDividedSlope(dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalDoubleHalfSlope(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopedStairs(dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return true;
        }
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return true;
        }
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SlopeSlabSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstInverseDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_ELEVATED_SLOPE_SLAB, BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstElevatedDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLAB, BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstStackedSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_SLAB, BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatStackedSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_SLAB, BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstInverseDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SLAB_EDGE, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLAB, partTargets={BlockType.FRAMED_SLAB})
    private static boolean testAgainstDoubleSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) != SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalDoubleHalfSlope(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean topHalf, boolean top, Direction side) {
        if (side == dir.m_122424_() || side == dir.m_122427_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            Direction shortEdge = side == dir.m_122424_() ? dir.m_122428_() : dir;
            return HalfTriangleDir.fromDirections(longEdge, shortEdge, topHalf == top);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean topHalf, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            return HalfDir.fromDirections(side, topHalf ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

