/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
public final class LargeInnerCornerSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstSmallDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstLargeDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstDoubleSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalDividedStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (LargeInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return LargeInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || LargeInnerCornerSlopePanelSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || LargeInnerCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return LargeInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SlopePanelSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || LargeInnerCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return LargeInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return LargeInnerCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, (BlockState)states.m_14418_(), side) || LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalStairs(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return LargeInnerCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalHalfStairs(dir, top, (BlockState)states.m_14418_(), side) || LargeInnerCornerSlopePanelSkipPredicate.testAgainstVerticalHalfStairs(dir, top, (BlockState)states.m_14419_(), side);
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side == dir) {
            return HalfTriangleDir.fromDirections(dir.m_122427_(), top ? Direction.UP : Direction.DOWN, true);
        }
        if (side == dir.m_122428_()) {
            return HalfTriangleDir.fromDirections(dir.m_122424_(), top ? Direction.UP : Direction.DOWN, true);
        }
        return HalfTriangleDir.NULL;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return TriangleDir.fromDirections(dir.m_122427_(), dir.m_122424_());
        }
        return TriangleDir.NULL;
    }
}

