/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
public final class FlatExtendedSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return switch (type) {
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatStackedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstInverseDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstStackedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDividedSlab(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDividedPanelHor(dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoublePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDividedPanelVert(dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoubleStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalDoubleStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDividedStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDividedSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoubleHalfSlope(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalSlopedStairs(dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return true;
        }
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstFlatStackedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return true;
        }
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXTENDED_SLOPE_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_PANEL, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstStackedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, rot, (BlockState)states.m_14418_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PANEL, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstDoublePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstStairs(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_STAIRS, BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalStairs(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14418_(), side) || FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, HorizontalRotation rot, Direction side) {
        Direction rotDir = rot.withFacing(dir);
        Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (side == rotDir.m_122424_() || side == perpRotDir.m_122424_()) {
            Direction shortEdge = side == rotDir.m_122424_() ? perpRotDir.m_122424_() : rotDir.m_122424_();
            return HalfTriangleDir.fromDirections(dir, shortEdge, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == rot.withFacing(dir) || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

