/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_INNER_PRISM_CORNER})
public final class InnerThreewayCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> InnerThreewayCornerSkipPredicate.testAgainstInnerThreewayCorner(dir, top, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> InnerThreewayCornerSkipPredicate.testAgainstThreewayCorner(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> InnerThreewayCornerSkipPredicate.testAgainstDoubleThreewayCorner(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstSlope(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstDoubleSlope(dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstCorner(dir, top, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstInnerCorner(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> InnerThreewayCornerSkipPredicate.testAgainstDoubleCorner(dir, top, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstHalfSlope(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstDividedSlope(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstDoubleHalfSlope(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> InnerThreewayCornerSkipPredicate.testAgainstVerticalDoubleHalfSlope(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> InnerThreewayCornerSkipPredicate.testAgainstSlopedStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> InnerThreewayCornerSkipPredicate.testAgainstVerticalSlopedStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_INNER_PRISM_CORNER})
    private static boolean testAgainstInnerThreewayCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_THREEWAY_CORNER, BlockType.FRAMED_PRISM_CORNER})
    private static boolean testAgainstThreewayCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_THREEWAY_CORNER, partTargets={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_THREEWAY_CORNER}), @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PRISM_CORNER, partTargets={BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_PRISM_CORNER})})
    private static boolean testAgainstDoubleThreewayCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerThreewayCornerSkipPredicate.testAgainstInnerThreewayCorner(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstThreewayCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE})
    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE})})
    private static boolean testAgainstSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        ISlopeBlock block = (ISlopeBlock)adjState.m_60734_();
        Direction adjDir = block.getFacing(adjState);
        SlopeType adjType = block.getSlopeType(adjState);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE, partTargets={BlockType.FRAMED_SLOPE})
    private static boolean testAgainstDoubleSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerThreewayCornerSkipPredicate.testAgainstSlope(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstSlope(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE})
    private static boolean testAgainstInnerCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_CORNER, partTargets={BlockType.FRAMED_INNER_CORNER_SLOPE, BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstDoubleCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerThreewayCornerSkipPredicate.testAgainstInnerCorner(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE, BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return InnerThreewayCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, top, (BlockState)states.m_14419_(), side);
        }
        return InnerThreewayCornerSkipPredicate.testAgainstHalfSlope(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstHalfSlope(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerThreewayCornerSkipPredicate.testAgainstHalfSlope(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstHalfSlope(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalDoubleHalfSlope(Direction dir, boolean top, BlockState adjState, Direction side) {
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerThreewayCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, top, (BlockState)states.m_14418_(), side) || InnerThreewayCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(SlopedStairsSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        if (Utils.isY(side) || side != dir.m_122424_() && side != dir.m_122427_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return InnerThreewayCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    public static TriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.UP || top && side == Direction.DOWN) {
            return TriangleDir.fromDirections(dir, dir.m_122428_());
        }
        if (side == dir.m_122424_()) {
            return TriangleDir.fromDirections(dir.m_122428_(), top ? Direction.UP : Direction.DOWN);
        }
        if (side == dir.m_122427_()) {
            return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
        }
        return TriangleDir.NULL;
    }
}

