/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_SLAB})
public final class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB -> SlabSkipPredicate.testAgainstSlab(top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlabSkipPredicate.testAgainstDoubleSlab(top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabSkipPredicate.testAgainstEdge(top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> SlabSkipPredicate.testAgainstDividedSlab(top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> SlabSkipPredicate.testAgainstDividedPanelHor(top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabSkipPredicate.testAgainstStairs(top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabSkipPredicate.testAgainstDoubleStairs(top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstElevatedSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstDoubleSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstElevatedDoubleSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstStackedSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> SlabSkipPredicate.testAgainstVerticalHalfStairs(top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> SlabSkipPredicate.testAgainstVerticalDividedStairs(top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> SlabSkipPredicate.testAgainstDividedSlope(top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> SlabSkipPredicate.testAgainstVerticalDoubleHalfSlope(top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> SlabSkipPredicate.testAgainstSlopedStairs(top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLAB, partTargets={BlockType.FRAMED_SLAB})
    private static boolean testAgainstDoubleSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstSlab(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstEdge(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstEdge(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstEdge(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstEdge(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstEdge(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstStairs(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstEdge(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstDoubleSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstInverseDoubleSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_ELEVATED_SLOPE_SLAB, BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstElevatedDoubleSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstElevatedSlopeSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLAB, BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstStackedSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstSlopeSlab(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatDoubleSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_SLAB})
    private static boolean testAgainstFlatStackedSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlab(top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_SLAB, BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstSlab(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(boolean top, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) != SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalDoubleHalfSlope(boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14418_(), side) || SlabSkipPredicate.testAgainstVerticalHalfStairs(top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    public static HalfDir getHalfDir(boolean top, Direction side) {
        if (!Utils.isY(side)) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

