/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.InnerSlopedPrismSkipPredicate;

@CullTest(value={BlockType.FRAMED_INNER_PRISM})
public final class InnerPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        if (side.m_122434_() != dirAxis.axis() || dirAxis.axis() == dirAxis.direction().m_122434_()) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_INNER_PRISM -> InnerPrismSkipPredicate.testAgainstInnerPrism(dirAxis, adjState, side);
                case BlockType.FRAMED_INNER_SLOPED_PRISM -> InnerPrismSkipPredicate.testAgainstInnerSlopedPrism(dirAxis, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM -> InnerPrismSkipPredicate.testAgainstDoublePrism(dirAxis, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPED_PRISM -> InnerPrismSkipPredicate.testAgainstDoubleSlopedPrism(dirAxis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_PRISM})
    private static boolean testAgainstInnerPrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.m_61143_(PropertyHolder.FACING_AXIS));
        return InnerPrismSkipPredicate.getTriDir(dirAxis, side).isEqualTo(InnerPrismSkipPredicate.getTriDir(adjDirAxis, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_SLOPED_PRISM})
    private static boolean testAgainstInnerSlopedPrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.m_61143_(PropertyHolder.FACING_DIR));
        return InnerPrismSkipPredicate.getTriDir(dirAxis, side).isEqualTo(InnerSlopedPrismSkipPredicate.getTriDir(adjCmpDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PRISM, partTargets={BlockType.FRAMED_INNER_PRISM})
    private static boolean testAgainstDoublePrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerPrismSkipPredicate.testAgainstInnerPrism(dirAxis, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPED_PRISM, partTargets={BlockType.FRAMED_INNER_SLOPED_PRISM})
    private static boolean testAgainstDoubleSlopedPrism(DirectionAxis dirAxis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return InnerPrismSkipPredicate.testAgainstInnerSlopedPrism(dirAxis, (BlockState)states.m_14418_(), side);
    }

    public static HalfDir getTriDir(DirectionAxis dirAxis, Direction side) {
        Direction dir = dirAxis.direction();
        Direction.Axis axis = dirAxis.axis();
        if (dir.m_122434_() != axis && side.m_122434_() == axis) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

