/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_FENCE})
public final class FenceSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_FENCE -> FenceSkipPredicate.testAgainstFence(state, adjState, side);
                case BlockType.FRAMED_FENCE_GATE -> FenceSkipPredicate.testAgainstFenceGate(state, adjState, side);
                case BlockType.FRAMED_POST -> FenceSkipPredicate.testAgainstPost(adjState, side);
                case BlockType.FRAMED_LATTICE_BLOCK -> FenceSkipPredicate.testAgainstLattice(adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(BlockState state, BlockState adjState, Direction side) {
        return Utils.isY(side) || FenceSkipPredicate.hasFenceArm(state, side) && FenceSkipPredicate.hasFenceArm(adjState, side.m_122424_());
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FENCE_GATE}, oneWay=true)
    private static boolean testAgainstFenceGate(BlockState state, BlockState adjState, Direction side) {
        if (!Utils.isY(side) && FenceSkipPredicate.hasFenceArm(state, side)) {
            Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
            return adjDir.m_122427_().m_122434_() == side.m_122434_();
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(BlockState adjState, Direction side) {
        return Utils.isY(side) && adjState.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(BlockState adjState, Direction side) {
        return Utils.isY(side) && (Boolean)adjState.m_61143_((Property)FramedProperties.Y_AXIS) != false;
    }

    private static boolean hasFenceArm(BlockState state, Direction side) {
        return switch (side) {
            case Direction.NORTH -> (Boolean)state.m_61143_((Property)FenceBlock.f_52309_);
            case Direction.EAST -> (Boolean)state.m_61143_((Property)FenceBlock.f_52310_);
            case Direction.SOUTH -> (Boolean)state.m_61143_((Property)FenceBlock.f_52311_);
            case Direction.WEST -> (Boolean)state.m_61143_((Property)FenceBlock.f_52312_);
            default -> throw new IllegalArgumentException("Invalid fence arm side: " + side);
        };
    }
}

