/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.WallSkipPredicate;

@CullTest(value={BlockType.FRAMED_FENCE_GATE})
public final class FenceGateSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object;
        boolean perp;
        Direction dir = (Direction)state.m_61143_((Property)FenceGateBlock.f_54117_);
        boolean bl = perp = dir.m_122427_().m_122434_() == side.m_122434_();
        if (perp && (object = adjState.m_60734_()) instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean inWall = (Boolean)state.m_61143_((Property)FenceGateBlock.f_53343_);
            return switch (type) {
                case BlockType.FRAMED_FENCE_GATE -> FenceGateSkipPredicate.testAgainstFenceGate(dir, inWall, adjState);
                case BlockType.FRAMED_WALL -> FenceGateSkipPredicate.testAgainstWall(inWall, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FENCE_GATE})
    private static boolean testAgainstFenceGate(Direction dir, boolean inWall, BlockState adjState) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FenceGateBlock.f_54117_);
        return adjDir.m_122434_() == dir.m_122434_() && inWall == (Boolean)adjState.m_61143_((Property)FenceGateBlock.f_53343_);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_WALL}, oneWay=true)
    private static boolean testAgainstWall(boolean inWall, BlockState adjState, Direction side) {
        return inWall && WallSkipPredicate.getArm(adjState, side.m_122424_()) != WallSide.NONE;
    }
}

