/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.ContainerType;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class BlockCamoContainer
extends CamoContainer {
    private BlockCamoContainer(BlockState state) {
        super(state);
    }

    @Override
    public int getColor(BlockAndTintGetter level, BlockPos pos, int tintIdx) {
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getBlockColor(level, pos, this.state, tintIdx);
        }
        throw new UnsupportedOperationException("Block color is not available on the server!");
    }

    @Override
    public ItemStack toItemStack(ItemStack stack) {
        return new ItemStack((ItemLike)this.state.m_60734_());
    }

    @Override
    public CamoContainer.Factory getFactory() {
        return (CamoContainer.Factory)FBContent.FACTORY_BLOCK.get();
    }

    @Override
    public ContainerType getType() {
        return ContainerType.BLOCK;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.state));
    }

    @Override
    public void toNetwork(CompoundTag tag) {
        tag.m_128405_("state", Block.m_49956_((BlockState)this.state));
    }

    public static final class Factory
    extends CamoContainer.Factory {
        @Override
        public CamoContainer fromNbt(CompoundTag tag) {
            BlockState state = NbtUtils.m_247651_(Utils.getBlockHolderLookup(null), (CompoundTag)tag.m_128469_("state"));
            return new BlockCamoContainer(state);
        }

        @Override
        public CamoContainer fromNetwork(CompoundTag tag) {
            BlockState state = Block.m_49803_((int)tag.m_128451_("state"));
            return new BlockCamoContainer(state);
        }

        @Override
        public CamoContainer fromItem(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                BlockState state = item2.m_40614_().m_49966_();
                return new BlockCamoContainer(state);
            }
            return EmptyCamoContainer.EMPTY;
        }
    }
}

