/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedCornerSlopePanelWallBlock
extends FramedBlock {
    public FramedExtendedCornerSlopePanelWallBlock(BlockType blockType) {
        super(blockType);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, FramedProperties.SOLID, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this.m_49966_(), ctx, this.getBlockType() == BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_EXT_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_()) break;
                side = dir;
                break;
            }
            case FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.m_82450_();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
            };
            VoxelShape preShape = ShapeUtils.andUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
            };
            VoxelShape preShape = ShapeUtils.orUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

