/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelBlock
extends FramedBlock {
    public static final ShapeCache<HorizontalRotation> SHAPES = new ShapeCache<HorizontalRotation>(new EnumMap(HorizontalRotation.class), map -> {
        map.put(HorizontalRotation.UP, ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));
        map.put(HorizontalRotation.RIGHT, ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));
        map.put(HorizontalRotation.DOWN, ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)0.5)));
        map.put(HorizontalRotation.LEFT, ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)0.5)));
    });

    public FramedSlopePanelBlock() {
        super(BlockType.FRAMED_SLOPE_PANEL);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCross(context.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        boolean front = false;
        if (side.m_122434_() != facing.m_122434_()) {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = Utils.isX(facing) ? subHit.f_82479_ : subHit.f_82481_;
            front = xz < 0.5 == Utils.isPositive(facing);
        }
        BlockState state = (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front));
        return FramedSlopePanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face.m_122434_() == dir.m_122434_() || face == rotation.withFacing(dir)) {
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction side = Direction.UP;
        if (state.m_61143_(PropertyHolder.ROTATION) == HorizontalRotation.UP) {
            side = Direction.DOWN;
        }
        return this.rotate(state, side, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    public static BlockState mirrorPanel(BlockState state, Mirror mirror) {
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (newState != state && !rot.isVertical()) {
            state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot.getOpposite()));
        }
        return state;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 16;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shape = SHAPES.get(rot);
            VoxelShape shapeFront = shape.m_83216_(0.0, 0.0, 0.5);
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, rot.ordinal() << 2);
            ShapeUtils.makeHorizontalRotations(shapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.m_122416_() | rot.ordinal() << 2 | front;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

