/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedThreewayCornerBlock
extends FramedBlock {
    public FramedThreewayCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedThreewayCornerBlock.withCornerFacing(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        state = FramedThreewayCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
        return FramedThreewayCornerBlock.withTop(state, context.m_43719_(), context.m_43720_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == dir.m_122424_() || face == dir.m_122427_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if ((face == dir || face == dir.m_122428_()) && rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)4.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)4.0, (double)0.5), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)0.5, (double)16.0, (double)0.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)15.5, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.5, (double)0.5, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.5, (double)4.0, (double)4.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)0.5, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)0.5, (double)0.5, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0));
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)4.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedThreewayCornerBlock.m_49796_((double)15.5, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.5, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)15.5, (double)4.0, (double)4.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.m_49796_((double)0.0, (double)15.5, (double)15.5, (double)0.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.m_49796_((double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

