/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedItemFrameBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameBlock
extends FramedBlock {
    private static final SoundType NORMAL_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.f_12014_, SoundEvents.f_271165_, SoundEvents.f_12015_, SoundEvents.f_12338_, SoundEvents.f_271165_);
    private static final SoundType GLOWING_SOUND = new SoundType(1.0f, 1.0f, SoundEvents.f_144155_, SoundEvents.f_271165_, SoundEvents.f_144156_, SoundEvents.f_12338_, SoundEvents.f_271165_);

    public FramedItemFrameBlock(BlockType type) {
        super(type, IFramedBlock.createProperties(type).m_60966_().m_60910_().m_60960_((s, l, p) -> false).m_60971_((s, l, p) -> false).m_60918_(type == BlockType.FRAMED_ITEM_FRAME ? NORMAL_SOUND : GLOWING_SOUND));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.LEATHER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.MAP_FRAME, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, PropertyHolder.LEATHER, PropertyHolder.MAP_FRAME});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face.m_122424_());
        if (this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return state;
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_121945_(dir));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity) {
            FramedItemFrameBlockEntity be = (FramedItemFrameBlockEntity)blockEntity;
            return be.handleFrameInteraction(player, hand);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        FramedItemFrameBlockEntity be;
        if (player.m_21205_().m_150930_((Item)FBContent.ITEM_FRAMED_HAMMER.get())) {
            if (!level.m_5776_()) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PropertyHolder.LEATHER));
            }
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            if (!level.m_5776_()) {
                be.removeItem(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.m_49962_(state);
    }

    @Override
    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @Override
    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        FramedItemFrameBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedItemFrameBlockEntity && (be = (FramedItemFrameBlockEntity)blockEntity).hasItem()) {
            return be.getCloneItem();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.f_61372_, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedItemFrameBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_() && ((Boolean)state.m_61143_((Property)PropertyHolder.MAP_FRAME)).booleanValue()) {
            return Utils.createBlockEntityTicker(type, FBContent.BE_TYPE_FRAMED_ITEM_FRAME.get(), (l, p, s, be) -> be.tickWithMap());
        }
        return null;
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new FramedBlockRenderProperties(){

            @Override
            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                return true;
            }

            @Override
            public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
                return true;
            }
        });
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape topShape = FramedItemFrameBlock.m_49796_((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        VoxelShape topMapShape = FramedItemFrameBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape bottomShape = FramedItemFrameBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
        VoxelShape bottomMapShape = FramedItemFrameBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape northShape = FramedItemFrameBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);
        VoxelShape northMapShape = FramedItemFrameBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotationsWithFlag(northShape, northMapShape, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            boolean map = (Boolean)state.m_61143_((Property)PropertyHolder.MAP_FRAME);
            builder.put((Object)state, (Object)(switch (dir) {
                case Direction.UP -> {
                    if (map) {
                        yield topMapShape;
                    }
                    yield topShape;
                }
                case Direction.DOWN -> {
                    if (map) {
                        yield bottomMapShape;
                    }
                    yield bottomShape;
                }
                default -> horShapes[dir.m_122416_() + (map ? 4 : 0)];
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

