/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.item;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import xfacthd.framedblocks.client.render.util.GhostVertexConsumer;
import xfacthd.framedblocks.common.compat.rubidium.RubidiumCompat;

public final class ItemRenderHelper {
    private static final RenderType TRANSLUCENT = RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_);
    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);

    public static void renderFakeItemTransparent(PoseStack poseStack, ItemStack stack, int x, int y, int alpha) {
        if (stack.m_41619_() || !RubidiumCompat.supportsCustomVertexConsumer()) {
            return;
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(stack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        ItemRenderHelper.renderItemModel(poseStack, stack, x, y, alpha, model, renderer);
    }

    public static void renderItemModel(PoseStack poseStack, ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        poseStack.m_85836_();
        poseStack.m_252880_((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        poseStack.m_252931_(SCALE_INVERT_Y);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        boolean bl = flatLight = !model.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, ItemRenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.m_6299_(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    private ItemRenderHelper() {
    }
}

