/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.block.sign.FramedStandingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;

public class FramedSignRenderer
implements BlockEntityRenderer<FramedSignBlockEntity> {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private static final float RENDER_SCALE = 0.6666667f;
    private static final Vector3f TEXT_OFFSET = new Vector3f(0.0f, 0.35f, 0.064f);
    private static final Vector3f WALL_TEXT_OFFSET = new Vector3f(0.0f, 0.334375f, 0.064f);
    private final Font font;

    public FramedSignRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
    }

    public void render(FramedSignBlockEntity sign, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = sign.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof AbstractFramedSignBlock)) {
            return;
        }
        AbstractFramedSignBlock signBlock = (AbstractFramedSignBlock)block;
        BlockPos pos = sign.m_58899_();
        int lineHeight = signBlock.getTextLineHeight();
        int lineWidth = signBlock.getMaxTextLineWidth();
        poseStack.m_85836_();
        this.applyTransforms(poseStack, -signBlock.getYRotationDegrees(state), state);
        this.renderText(pos, signBlock, sign.getFrontText(), poseStack, buffer, light, lineHeight, lineWidth, true);
        this.renderText(pos, signBlock, sign.getBackText(), poseStack, buffer, light, lineHeight, lineWidth, false);
        poseStack.m_85849_();
    }

    protected void applyTransforms(PoseStack poseStack, float yRot, BlockState state) {
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        if (!(state.m_60734_() instanceof FramedStandingSignBlock)) {
            poseStack.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    private void applyTextTransforms(PoseStack poseStack, AbstractFramedSignBlock signBlock, boolean front) {
        if (!front) {
            poseStack.m_252781_(Quaternions.YP_180);
        }
        Vector3f offset = this.getTextOffset(signBlock);
        poseStack.m_252880_(offset.x, offset.y, offset.z);
        float scale = 0.015625f * this.getSignTextRenderScale();
        poseStack.m_85841_(scale, -scale, scale);
    }

    protected float getSignTextRenderScale() {
        return 0.6666667f;
    }

    protected Vector3f getTextOffset(AbstractFramedSignBlock signBlock) {
        boolean standing = signBlock instanceof FramedStandingSignBlock;
        return standing ? TEXT_OFFSET : WALL_TEXT_OFFSET;
    }

    private void renderText(BlockPos pos, AbstractFramedSignBlock signBlock, SignText text, PoseStack poseStack, MultiBufferSource buffer, int light, int lineHeight, int lineWidth, boolean front) {
        int textLight;
        boolean outline;
        int textColor;
        poseStack.m_85836_();
        this.applyTextTransforms(poseStack, signBlock, front);
        int darkColor = FramedSignRenderer.getDarkTextColor(text);
        if (text.m_276843_()) {
            textColor = text.m_276773_().m_41071_();
            outline = FramedSignRenderer.showOutline(pos, textColor);
            textLight = 0xF000F0;
        } else {
            textColor = darkColor;
            outline = false;
            textLight = light;
        }
        boolean filter = Minecraft.m_91087_().m_167974_();
        FormattedCharSequence[] lines = text.m_277130_(filter, line -> {
            List parts = this.font.m_92923_((FormattedText)line, lineWidth);
            return parts.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)parts.get(0);
        });
        int centerY = 4 * lineHeight / 2;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        for (int idx = 0; idx < 4; ++idx) {
            FormattedCharSequence line2 = lines[idx];
            float textX = (float)(-this.font.m_92724_(line2)) / 2.0f;
            float textY = idx * lineHeight - centerY;
            if (outline) {
                this.font.m_168645_(line2, textX, textY, textColor, darkColor, pose, buffer, textLight);
                continue;
            }
            this.font.m_272191_(line2, textX, textY, textColor, false, pose, buffer, Font.DisplayMode.POLYGON_OFFSET, 0, textLight);
        }
        poseStack.m_85849_();
    }

    private static int getDarkTextColor(SignText text) {
        int color = text.m_276773_().m_41071_();
        if (color == DyeColor.BLACK.m_41071_() && text.m_276843_()) {
            return -988212;
        }
        int r = (int)((double)FastColor.ARGB32.m_13665_((int)color) * 0.4);
        int g = (int)((double)FastColor.ARGB32.m_13667_((int)color) * 0.4);
        int b = (int)((double)FastColor.ARGB32.m_13669_((int)color) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)r, (int)g, (int)b);
    }

    private static boolean showOutline(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && mc.f_91074_.m_150108_()) {
            return true;
        }
        Entity camera = mc.m_91288_();
        return camera != null && camera.m_20238_(Vec3.m_82512_((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }
}

