/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.torch;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelCache;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;

public class FramedRedstoneWallTorchModel
extends FramedBlockModel {
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.0f, 0.21875f, 0.5f);
    private static final float MIN = 0.4375f;
    private static final float MAX = 0.5625f;
    private static final float TOP = 0.71875f;
    private static final float BOTTOM = 0.78125f;
    private final Direction dir;
    private final boolean lit;

    public FramedRedstoneWallTorchModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.lit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelCache.getRenderTypes(Blocks.f_50123_.m_49966_(), rand, extraData);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData extraData, RenderType renderType) {
        List quads = this.baseModel.getQuads(state, null, rand, extraData, renderType);
        for (BakedQuad quad : quads) {
            if (ClientUtils.isDummyTexture(quad)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            float top = this.lit ? 0.65625f : 0.71875f;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? top : 0.78125f)).apply(Modifiers.offset(Direction.WEST, 0.5f)).export(quadMap.get(null));
        } else {
            boolean xAxis = Utils.isX(quadDir);
            boolean east = quadDir == Direction.EAST;
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.0f, 0.5625f, this.lit ? 0.4375f : 0.5f)).applyIf(Modifiers.setPosition(east ? 0.0625f : 1.0625f), xAxis).applyIf(Modifiers.setPosition(0.5625f), !xAxis).applyIf(Modifiers.offset(Direction.WEST, 0.5f), !xAxis).apply(Modifiers.offset(Direction.UP, 0.21875f)).export(quadMap.get(null));
        }
    }

    @Override
    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
        float yAngle = 270.0f - this.dir.m_122435_();
        quadMap.get(null).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.rotate(Direction.Axis.Z, ROTATION_ORIGIN, -22.5f, false)).apply(Modifiers.rotateCentered(Direction.Axis.Y, yAngle, false)).modifyInPlace());
    }

    @Override
    public boolean m_7541_() {
        return false;
    }
}

