/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedLadderModel
extends FramedBlockModel {
    private static final float RUNG_DEPTH = 0.0625f;
    private static final float LEG_DEPTH = 0.125f;
    private static final float RUNG_OFFSET = 0.03125f;
    private static final float[] RUNGS = new float[]{0.09375f, 0.34375f, 0.59375f, 0.84375f};
    private final Direction dir;

    public FramedLadderModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier capMod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.125f));
            capMod.derive().apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.125f)).export(quadMap.get(quadDir));
            capMod.apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.125f)).export(quadMap.get(quadDir));
            QuadModifier rungMod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.96875f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.09375f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.875f)).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.875f));
            for (int i = 0; i < 4; ++i) {
                float height = quad.m_111306_() == Direction.DOWN ? 1.0f - RUNGS[i] : RUNGS[i] + 0.0625f;
                rungMod.apply(Modifiers.setPosition(height)).export(quadMap.get(null));
            }
        } else if (quadDir.m_122434_() == this.dir.m_122434_()) {
            boolean opposite = quadDir == this.dir.m_122424_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.125f)).applyIf(Modifiers.setPosition(0.125f), opposite).export(quadMap.get(opposite ? null : quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), 0.125f)).applyIf(Modifiers.setPosition(0.125f), opposite).export(quadMap.get(opposite ? null : quadDir));
            float pos = quad.m_111306_() == this.dir ? 0.96875f : 0.09375f;
            for (int i = 0; i < 4; ++i) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.125f, RUNGS[i], 0.875f, RUNGS[i] + 0.0625f)).apply(Modifiers.setPosition(pos)).export(quadMap.get(null));
            }
        } else {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.125f));
            mod.export(quadMap.get(quadDir));
            mod.apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_LADDER.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

