/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.test;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.test.TestDelay;
import xfacthd.framedblocks.api.test.TestRunnable;
import xfacthd.framedblocks.api.util.Utils;

public final class TestUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockPos OCCLUSION_BLOCK_TOP_BOTTOM = new BlockPos(1, 3, 1);
    private static final BlockPos OCCLUSION_BLOCK_SIDE = new BlockPos(1, 2, 2);
    private static final BlockPos OCCLUSION_LIGHT_TOP = new BlockPos(1, 4, 1);
    private static final BlockPos OCCLUSION_LIGHT_BOTTOM = new BlockPos(1, 2, 1);
    private static final BlockPos OCCLUSION_LIGHT_SIDE = new BlockPos(1, 2, 3);
    private static final BlockPos EMISSION_BLOCK = new BlockPos(1, 2, 1);
    private static final BlockPos EMISSION_LIGHT = new BlockPos(1, 3, 1);
    private static final BlockPos INTANGIBILITY_BLOCK = new BlockPos(0, 1, 0);
    private static final BlockPos BEACON_TINT_BLOCK = new BlockPos(0, 1, 0);
    private static final BlockPos BEACON_TINT_BEACON = new BlockPos(0, 0, 0);
    private static final Predicate<float[]> BEACON_PREDICATE_RED = arr -> Arrays.equals(arr, DyeColor.RED.m_41068_());
    private static final String BEACON_COLOR_TEXT_RED = Arrays.toString(DyeColor.RED.m_41068_());

    public static boolean assertFramedBlock(GameTestHelper helper, Block block) {
        if (!(block instanceof IFramedBlock)) {
            helper.m_177284_(String.format("Expected instance of IFramedBlock, got %s", ForgeRegistries.BLOCKS.getKey((Object)block)));
            return false;
        }
        return true;
    }

    public static void applyCamo(GameTestHelper helper, BlockPos pos, Block camo, List<Direction> camoSides) {
        LinkedHashMap<Direction, Block> camos = new LinkedHashMap<Direction, Block>();
        camoSides.forEach(side -> camos.put((Direction)side, camo));
        TestUtils.applyCamo(helper, pos, camos);
    }

    public static void applyCamo(GameTestHelper helper, BlockPos pos, Map<Direction, Block> camos) {
        BlockPos absPos = helper.m_177449_(pos);
        Player player = helper.m_177368_();
        int count = 0;
        for (Map.Entry<Direction, Block> entry : camos.entrySet()) {
            Direction side = entry.getKey();
            Block camo = entry.getValue();
            Item item = camo == Blocks.f_50016_ ? (Item)Utils.FRAMED_HAMMER.get() : camo.m_5456_();
            player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)item));
            Vec3 hitVec = switch (count) {
                case 0 -> Vec3.m_82512_((Vec3i)absPos).m_82520_(-0.1, -0.1, -0.1);
                case 1 -> Vec3.m_82512_((Vec3i)absPos).m_82520_(0.1, 0.1, 0.1);
                default -> Vec3.m_82512_((Vec3i)absPos);
            };
            InteractionResult result = helper.m_177232_(pos).m_60664_((Level)helper.m_177100_(), player, InteractionHand.MAIN_HAND, new BlockHitResult(hitVec, side, absPos, true));
            ++count;
            if (result.m_146666_()) continue;
            helper.m_177289_(String.format("Camo application on side '%s' of block '%s' failed", side, helper.m_177232_(pos)), pos);
        }
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item) {
        TestUtils.clickWithItem(helper, pos, item, Direction.UP, false);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, boolean sneak) {
        TestUtils.clickWithItem(helper, pos, item, Direction.UP, sneak);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, Direction side) {
        TestUtils.clickWithItem(helper, pos, item, side, false);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, Direction side, boolean sneak) {
        BlockPos absPos = helper.m_177449_(pos);
        Player player = helper.m_177368_();
        player.m_146884_(absPos.m_121945_(side).m_252807_());
        player.m_20260_(sneak);
        player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack(item));
        InteractionResult result = helper.m_177232_(pos).m_60664_((Level)helper.m_177100_(), player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)absPos), side, absPos, true));
        if (!result.m_146666_()) {
            helper.m_177289_(String.format("Interaction with block %s failed", helper.m_177232_(pos)), pos);
        }
    }

    public static void attackWithItem(GameTestHelper helper, BlockPos pos, ItemLike item) {
        Player player = helper.m_177368_();
        player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack(item));
        ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)helper.m_177449_(pos), (Direction)Direction.UP);
    }

    public static int chainTasks(GameTestHelper helper, List<TestRunnable> tasks) {
        return TestUtils.chainTasks(helper, tasks, 0);
    }

    public static int chainTasks(GameTestHelper helper, List<TestRunnable> tasks, int initialDelay) {
        int delay = initialDelay;
        for (TestRunnable task : tasks) {
            helper.m_177306_((long)delay, (Runnable)task);
            delay += task.getDuration();
        }
        return delay;
    }

    public static <T extends BlockEntity> T getBlockEntity(GameTestHelper helper, BlockPos relPos, Class<T> beClass) {
        BlockEntity be = helper.m_177347_(relPos);
        if (be == null) {
            throw new GameTestAssertPosException(String.format("Expected %s, got null", beClass.getSimpleName()), helper.m_177449_(relPos), relPos, helper.m_177436_());
        }
        if (!beClass.isInstance(be)) {
            throw new GameTestAssertPosException(String.format("Expected %s, got %s", beClass.getSimpleName(), be.getClass().getSimpleName()), helper.m_177449_(relPos), relPos, helper.m_177436_());
        }
        return (T)((BlockEntity)beClass.cast(be));
    }

    public static void assertTrue(GameTestHelper helper, BlockPos relPos, boolean value, Supplier<String> message) {
        if (!value) {
            throw new GameTestAssertPosException(message.get(), helper.m_177449_(relPos), relPos, helper.m_177436_());
        }
    }

    public static void spawnItemCentered(GameTestHelper helper, Item item, BlockPos relPos) {
        helper.m_177189_(item, (float)relPos.m_123341_() + 0.5f, (float)relPos.m_123342_(), (float)relPos.m_123343_() + 0.5f);
    }

    public static boolean assertCanOcclude(GameTestHelper helper, Block block) {
        if (!TestUtils.assertFramedBlock(helper, block)) {
            return false;
        }
        if (!((IFramedBlock)block).getBlockType().canOccludeWithSolidCamo()) {
            helper.m_177284_(String.format("Block %s can not occlude with a solid camo", ForgeRegistries.BLOCKS.getKey((Object)block)));
            return false;
        }
        return true;
    }

    public static void testBlockOccludesLightBelow(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_TOP, state, List.of(Direction.UP));
    }

    public static void testBlockOccludesLightAbove(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_BOTTOM, state, List.of(Direction.DOWN));
    }

    public static void testBlockOccludesLightNorth(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_SIDE, OCCLUSION_LIGHT_SIDE, state, List.of(Direction.SOUTH));
    }

    public static void testDoubleBlockOccludesLightBelow(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_TOP, state, camoSides);
    }

    public static void testDoubleBlockOccludesLightAbove(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_BOTTOM, state, camoSides);
    }

    public static void testDoubleBlockOccludesLightNorth(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_SIDE, OCCLUSION_LIGHT_SIDE, state, camoSides);
    }

    private static void testBlockOccludesLight(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, BlockState state, List<Direction> camoSides) {
        if (!TestUtils.assertCanOcclude(helper, state.m_60734_())) {
            return;
        }
        helper.m_177208_(Blocks.f_50016_, blockPos);
        helper.m_177208_(Blocks.f_50058_, lightPos);
        TestRunnable[] testRunnableArray = new TestRunnable[11];
        testRunnableArray[0] = () -> helper.m_177252_(blockPos, state);
        testRunnableArray[1] = new TestDelay(5);
        testRunnableArray[2] = () -> {
            helper.m_177255_(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 13);
        };
        testRunnableArray[3] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.f_50058_, camoSides);
        testRunnableArray[4] = new TestDelay(5);
        testRunnableArray[5] = () -> {
            helper.m_177255_(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 13);
        };
        testRunnableArray[6] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.f_50016_, camoSides);
        testRunnableArray[7] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.f_50122_, camoSides);
        testRunnableArray[8] = new TestDelay(5);
        testRunnableArray[9] = () -> {
            helper.m_177255_(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(true));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 0);
        };
        testRunnableArray[10] = () -> ((GameTestHelper)helper).m_177412_();
        TestUtils.chainTasks(helper, List.of(testRunnableArray));
    }

    public static void testBlockLightEmission(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockLightEmission(helper, state, camoSides, 0);
    }

    public static void testBlockLightEmission(GameTestHelper helper, BlockState state, List<Direction> camoSides, int baseEmission) {
        int glowstoneLight = Blocks.f_50141_.m_49966_().m_60791_();
        TestRunnable[] testRunnableArray = new TestRunnable[19];
        testRunnableArray[0] = () -> helper.m_177252_(EMISSION_BLOCK, state);
        testRunnableArray[1] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, baseEmission);
        testRunnableArray[2] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50141_, camoSides);
        testRunnableArray[3] = new TestDelay(5);
        testRunnableArray[4] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, glowstoneLight);
        testRunnableArray[5] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50016_, camoSides);
        testRunnableArray[6] = new TestDelay(5);
        testRunnableArray[7] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, baseEmission);
        testRunnableArray[8] = () -> TestUtils.clickWithItem(helper, EMISSION_BLOCK, (ItemLike)Items.f_42525_);
        testRunnableArray[9] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[10] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50058_, camoSides);
        testRunnableArray[11] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[12] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50016_, camoSides);
        testRunnableArray[13] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[14] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50122_, camoSides);
        testRunnableArray[15] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[16] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.f_50016_, camoSides);
        testRunnableArray[17] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[18] = () -> ((GameTestHelper)helper).m_177412_();
        TestUtils.chainTasks(helper, List.of(testRunnableArray));
    }

    public static void assertBlockLightEmission(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, int light) {
        int emission = helper.m_177100_().m_7146_(helper.m_177449_(blockPos));
        if (emission != light) {
            BlockState state = helper.m_177232_(blockPos);
            throw new GameTestAssertPosException(String.format("Incorrect light emission for %s, expected %d, got %d", state, light, emission), helper.m_177449_(lightPos), lightPos, helper.m_177436_());
        }
        TestUtils.assertBlockLight(helper, blockPos, lightPos, Math.max(light - 1, 0));
    }

    private static void assertBlockLight(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, int light) {
        int actualLight = helper.m_177100_().m_5518_().m_75831_(helper.m_177449_(lightPos), 15);
        if (actualLight != light) {
            BlockState state = helper.m_177232_(blockPos);
            throw new GameTestAssertPosException(String.format("Incorrect light level for %s, expected %d, got %d", state, light, actualLight), helper.m_177449_(lightPos), lightPos, helper.m_177436_());
        }
    }

    public static void testBlockIntangibility(GameTestHelper helper, BlockState state) {
        if (!FramedBlocksAPI.getInstance().enableIntangibility()) {
            helper.m_177284_("Intangibility is not enabled in the ServerConfig");
        }
        TestUtils.chainTasks(helper, List.of(() -> helper.m_177252_(INTANGIBILITY_BLOCK, state), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(CollisionContext.m_82749_()), () -> String.format("Block '%s' is intangible without interaction", state.m_60734_()));
            BlockPos pos = helper.m_177449_(INTANGIBILITY_BLOCK);
            BlockState currState = helper.m_177232_(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.m_60651_((BlockGetter)helper.m_177100_(), pos, CollisionContext.m_82749_()).m_83281_(), () -> String.format("Block '%s' returns an empty shape when not intangible", state.m_60734_()));
        }, () -> TestUtils.clickWithItem(helper, INTANGIBILITY_BLOCK, (ItemLike)FramedBlocksAPI.getInstance().getIntangibilityMarkerItem()), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, be.isIntangible(CollisionContext.m_82749_()), () -> String.format("Block '%s' is not intangible after interaction", state.m_60734_()));
            BlockPos pos = helper.m_177449_(INTANGIBILITY_BLOCK);
            BlockState currState = helper.m_177232_(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, currState.m_60651_((BlockGetter)helper.m_177100_(), pos, CollisionContext.m_82749_()).m_83281_(), () -> String.format("Block '%s' does not return an empty shape when intangible", state.m_60734_()));
            Player player = helper.m_177368_();
            CollisionContext ctx = CollisionContext.m_82750_((Entity)player);
            ForgeRegistries.ITEMS.tags().getTag(Utils.DISABLE_INTANGIBLE).stream().forEach(item -> {
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)item));
                TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(ctx), () -> String.format("Block '%s' is intangible when targetted by item '%s' which is tagged with 'framedblocks:disable_intangible'", state.m_60734_(), item));
                TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.m_60651_((BlockGetter)helper.m_177100_(), pos, ctx).m_83281_(), () -> String.format("Block '%s' is intangible when targetted by item '%s' which is tagged with 'framedblocks:disable_intangible'", state.m_60734_(), item));
            });
            if (FMLEnvironment.dist.isClient()) {
                ClientGuard.testHasParticleOverride(helper, state);
            } else {
                LOGGER.warn("Can't test particle override of block '{}', running on dedicated server", (Object)state.m_60734_());
            }
        }, () -> TestUtils.clickWithItem(helper, INTANGIBILITY_BLOCK, (ItemLike)Utils.FRAMED_SCREWDRIVER.get(), true), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(CollisionContext.m_82749_()), () -> String.format("Block '%s' is intangible after removing marker", state.m_60734_()));
            BlockPos pos = helper.m_177449_(INTANGIBILITY_BLOCK);
            BlockState currState = helper.m_177232_(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.m_60651_((BlockGetter)helper.m_177100_(), pos, CollisionContext.m_82749_()).m_83281_(), () -> String.format("Block '%s' does returns an empty shape after removing marker", state.m_60734_()));
        }, () -> ((GameTestHelper)helper).m_177412_()));
    }

    public static void testBeaconBeamTinting(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.chainTasks(helper, List.of(() -> helper.m_177252_(BEACON_TINT_BLOCK, state), () -> TestUtils.assertBeaconTint(helper, Blocks.f_50016_, Objects::isNull, "null"), () -> TestUtils.applyCamo(helper, BEACON_TINT_BLOCK, Blocks.f_50214_, camoSides), () -> TestUtils.assertBeaconTint(helper, Blocks.f_50214_, BEACON_PREDICATE_RED, BEACON_COLOR_TEXT_RED), () -> ((GameTestHelper)helper).m_177412_()));
    }

    private static void assertBeaconTint(GameTestHelper helper, Block camo, Predicate<float[]> predicate, String expected) {
        BlockState state = helper.m_177232_(BEACON_TINT_BLOCK);
        TestUtils.assertFramedBlock(helper, state.m_60734_());
        float[] tint = state.getBeaconColorMultiplier((LevelReader)helper.m_177100_(), helper.m_177449_(BEACON_TINT_BLOCK), helper.m_177449_(BEACON_TINT_BEACON));
        TestUtils.assertTrue(helper, BEACON_TINT_BLOCK, predicate.test(tint), () -> String.format("Block '%s' applies incorrect beacon color multiplier for camo '%s', expected %s, got %s", state.m_60734_(), camo, expected, Arrays.toString(tint)));
    }

    private TestUtils() {
    }

    private static final class ClientGuard {
        private ClientGuard() {
        }

        public static void testHasParticleOverride(GameTestHelper helper, BlockState state) {
            IClientBlockExtensions blockExt = IClientBlockExtensions.of((BlockState)state);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, blockExt instanceof FramedBlockRenderProperties, () -> String.format("Block '%s' doesn't have required IClientBlockExtensions", state.m_60734_()));
            BlockPos pos = helper.m_177449_(INTANGIBILITY_BLOCK);
            BlockHitResult miss = BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.UP, (BlockPos)pos);
            boolean hit = false;
            boolean destroy = false;
            try {
                ParticleEngine engine = Minecraft.m_91087_().f_91061_;
                hit = blockExt.addHitEffects(state, (Level)helper.m_177100_(), (HitResult)miss, engine);
                destroy = blockExt.addDestroyEffects(state, (Level)helper.m_177100_(), pos, engine);
            }
            catch (Throwable e) {
                helper.m_177284_(String.format("Error while testing particle overrides, likely caused by a misconfigured particle override:\n%s", e));
            }
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, hit, () -> String.format("Block '%s' doesn't handle hit particles", state.m_60734_()));
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, destroy, () -> String.format("Block '%s' doesn't handle destroy particles", state.m_60734_()));
        }
    }
}

