/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class MonsterAIWalkThroughHallsOfStructure
extends RandomStrollGoal {
    private TagKey<Structure> structureTagKey;
    private double maximumDistance = 0.0;
    private double maximumYDistance = 3.0;

    public MonsterAIWalkThroughHallsOfStructure(PathfinderMob mob, double speed, int chance, TagKey<Structure> structureTagKey, double maximumDistance) {
        super(mob, speed, chance, false);
        this.structureTagKey = structureTagKey;
        this.maximumDistance = 32.0;
    }

    @Nullable
    protected Vec3 m_7037_() {
        StructureStart start = this.getNearestStructure(this.f_25725_.m_20183_());
        if (start.m_73603_()) {
            ArrayList<BlockPos> validPieceCenters = new ArrayList<BlockPos>();
            for (StructurePiece piece : start.m_73602_()) {
                BoundingBox boundingbox = piece.m_73547_();
                BlockPos blockpos = boundingbox.m_162394_();
                BlockPos blockpos1 = new BlockPos(blockpos.m_123341_(), boundingbox.m_162396_(), blockpos.m_123343_());
                double yDist = Math.abs(blockpos1.m_123342_() - this.f_25725_.m_20183_().m_123342_());
                if (!(this.f_25725_.m_20238_(Vec3.m_82512_((Vec3i)blockpos1)) <= this.maximumDistance * this.maximumDistance) || !(yDist < this.maximumYDistance)) continue;
                validPieceCenters.add(blockpos1);
            }
            if (!validPieceCenters.isEmpty()) {
                BlockPos randomCenter = validPieceCenters.size() > 1 ? (BlockPos)validPieceCenters.get(this.f_25725_.m_217043_().m_188503_(validPieceCenters.size() - 1)) : (BlockPos)validPieceCenters.get(0);
                return Vec3.m_82512_((Vec3i)randomCenter.m_7918_(this.f_25725_.m_217043_().m_188503_(2) - 1, 0, this.f_25725_.m_217043_().m_188503_(2) - 1));
            }
        }
        return this.getPositionTowardsAnywhere();
    }

    @Nullable
    private Vec3 getPositionTowardsAnywhere() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
    }

    private StructureStart getNearestStructure(BlockPos pos) {
        ServerLevel serverlevel = (ServerLevel)this.f_25725_.m_9236_();
        StructureStart start = serverlevel.m_215010_().m_220491_(pos, this.structureTagKey);
        if (start.m_73603_()) {
            return start;
        }
        BlockPos nearestOf = serverlevel.m_215011_(this.structureTagKey, pos, (int)(this.maximumDistance / 16.0), false);
        if (nearestOf == null || nearestOf.m_203198_(this.f_25725_.m_20185_(), this.f_25725_.m_20186_(), this.f_25725_.m_20189_()) > 256.0 || !serverlevel.m_46749_(nearestOf)) {
            return StructureStart.f_73561_;
        }
        return serverlevel.m_215010_().m_220491_(nearestOf, this.structureTagKey);
    }
}

