/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.SoundPhysicsMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL11;

public class Loggers {
    private static final String LOG_PREFIX = "Sound Physics - %s";
    public static final Logger DEBUG_LOGGER = LogManager.getLogger((String)String.format("Sound Physics - %s", "Debug"));
    public static final Logger ENVIRONMENT_LOGGER = LogManager.getLogger((String)String.format("Sound Physics - %s", "Environment"));
    public static final Logger OCCLUSION_LOGGER = LogManager.getLogger((String)String.format("Sound Physics - %s", "Occlusion"));
    public static final Logger LOGGER = LogManager.getLogger((String)String.format("Sound Physics - %s", "General"));

    protected static void logOcclusion(String message, Object ... args) {
        if (!SoundPhysicsMod.CONFIG.occlusionLogging.get().booleanValue()) {
            return;
        }
        OCCLUSION_LOGGER.info(message, args);
    }

    protected static void logEnvironment(String message, Object ... args) {
        if (!SoundPhysicsMod.CONFIG.environmentLogging.get().booleanValue()) {
            return;
        }
        ENVIRONMENT_LOGGER.info(message, args);
    }

    protected static void logDebug(String message, Object ... args) {
        if (!SoundPhysicsMod.CONFIG.debugLogging.get().booleanValue()) {
            return;
        }
        DEBUG_LOGGER.info(message, args);
    }

    public static void logALError(String errorMessage) {
        int error = AL11.alGetError();
        if (error == 0) {
            return;
        }
        String errorName = switch (error) {
            case 40961 -> "AL_INVALID_NAME";
            case 40962 -> "AL_INVALID_ENUM";
            case 40963 -> "AL_INVALID_VALUE";
            case 40964 -> "AL_INVALID_OPERATION";
            case 40965 -> "AL_OUT_OF_MEMORY";
            default -> Integer.toString(error);
        };
        LOGGER.error("{}: OpenAL error {}", (Object)errorMessage, (Object)errorName);
    }
}

