/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.registry;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigRegistry {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec.BooleanValue LOGSPAM;
    private static ForgeConfigSpec.IntValue REFRESHTICKS;
    public static ForgeConfigSpec.IntValue EXCHANGEBUFFER;
    private static ForgeConfigSpec.BooleanValue RELOADONCHUNK;
    private static ForgeConfigSpec.ConfigValue<List<String>> IGNORELIST;
    public static ForgeConfigSpec.IntValue ITEMRANGE;
    public static ForgeConfigSpec.IntValue RECIPEMAXTAGS;

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("storagenetwork");
        LOGSPAM = COMMON_BUILDER.comment("Enable very spammy logs.  Sometimes useful for debugging. ").define("logSpam", false);
        RELOADONCHUNK = COMMON_BUILDER.comment("\r\n If this is true, reload network when a chunk unloads, this keeps your network always up to date.  It has been reported that this cause lag and chunk load issues on servers, so disable if you have any problems. ").define("reloadNetworkWhenUnloadChunk", false);
        REFRESHTICKS = COMMON_BUILDER.comment("\r\n How often to auto-refresh a network (one second is 20 ticks)").defineInRange("autoRefreshTicks", 20, 2, 4096);
        ArrayList<String> list = new ArrayList<String>();
        list.add("extrautils2:playerchest");
        IGNORELIST = COMMON_BUILDER.comment("\r\n Disable these blocks from ever being able to connect to the network, they will be treated as a non-inventory.").define("NotallowedBlocks", list);
        EXCHANGEBUFFER = COMMON_BUILDER.comment("\r\n How many itemstacks from the network are visible to external connections through the storagenetwork:exchange.  Too low and not all items can pass through, too large and there will be packet/buffer overflows.").defineInRange("exchangeBufferSize", 1024, 1, 5000);
        ITEMRANGE = COMMON_BUILDER.comment("\r\n Maximum range of the Storage Remote and Crafting Remote.   -1 means unlimited.").defineInRange("remoteMaxRange", -1, -1, 0x7FFFFF);
        RECIPEMAXTAGS = COMMON_BUILDER.comment("\r\n When matching items to recipes in the JEI + button, this is the maximum number of tags to serialize over the network when on a server.  Reduce if you get errors relating to Packet Sizes being too large (Minecraft 1.12.2 had this hardcoded at 5).").defineInRange("jeiMaximumRecipeTags", 64, 5, 128);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public ConfigRegistry(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public boolean logspam() {
        return (Boolean)LOGSPAM.get();
    }

    public boolean doReloadOnChunk() {
        return (Boolean)RELOADONCHUNK.get();
    }

    public int refreshTicks() {
        return (Integer)REFRESHTICKS.get();
    }

    public List<String> ignorelist() {
        return (List)IGNORELIST.get();
    }

    static {
        ConfigRegistry.initConfig();
    }
}

