/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.network.StackResponseClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RequestMessage {
    private int mouseButton = 0;
    private ItemStack stack = ItemStack.f_41583_;
    private boolean shift;
    private boolean ctrl;

    public String toString() {
        return "RequestMessage [mouseButton=" + this.mouseButton + ", shift=" + this.shift + ", ctrl=" + this.ctrl + ", stack=" + this.stack.toString() + "]";
    }

    public RequestMessage() {
    }

    public RequestMessage(int id, ItemStack stackIn, boolean shift, boolean ctrl) {
        this.mouseButton = id;
        this.stack = stackIn.m_41777_();
        if (this.stack.m_41613_() > 64) {
            this.stack.m_41764_(64);
        }
        this.shift = shift;
        this.ctrl = ctrl;
    }

    public static void handle(RequestMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileMain root = null;
            ContainerNetwork ctr = null;
            if (player.f_36096_ instanceof ContainerNetwork) {
                ctr = (ContainerNetwork)player.f_36096_;
                root = ctr.getTileMain();
            } else {
                StorageNetworkMod.log("Bad container");
            }
            if (root == null) {
                StorageNetworkMod.log("Request message cancelled, null tile");
                return;
            }
            int in = root.nw.getAmount(new ItemStackMatcher(message.stack, false, true));
            boolean isLeftClick = message.mouseButton == 0;
            boolean isRightClick = message.mouseButton == 1;
            int sizeRequested = 0;
            if (message.ctrl) {
                sizeRequested = 1;
            } else if (isLeftClick) {
                sizeRequested = message.stack.m_41741_();
            } else if (isRightClick) {
                sizeRequested = Math.min(message.stack.m_41741_() / 2, in / 2);
            }
            sizeRequested = Math.max(sizeRequested, 1);
            boolean ore = false;
            boolean nbt = true;
            ItemStack stack = root.request(new ItemStackMatcher(message.stack, ore, nbt), sizeRequested, false);
            if (stack.m_41619_()) {
                nbt = false;
                stack = root.request(new ItemStackMatcher(message.stack, ore, nbt), sizeRequested, false);
            }
            if (!stack.m_41619_()) {
                if (message.shift) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                } else {
                    player.f_36096_.m_142503_(stack);
                    PacketRegistry.INSTANCE.sendTo((Object)new StackResponseClientMessage(stack), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
            List<ItemStack> list = root.nw.getSortedStacks();
            PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            player.f_36096_.m_38946_();
        });
        ctx.get().setPacketHandled(true);
    }

    public static RequestMessage decode(FriendlyByteBuf buf) {
        RequestMessage msg = new RequestMessage();
        msg.mouseButton = buf.readInt();
        msg.stack = ItemStack.m_41712_((CompoundTag)buf.m_130260_());
        msg.shift = buf.readBoolean();
        msg.ctrl = buf.readBoolean();
        return msg;
    }

    public static void encode(RequestMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.mouseButton);
        buf.m_130079_(msg.stack.serializeNBT());
        buf.writeBoolean(msg.shift);
        buf.writeBoolean(msg.ctrl);
    }
}

