/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public abstract class SelectDeviceScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_audio_devices.png");
    protected static final Component BACK = Component.m_237115_((String)"message.voicechat.back");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    @Nullable
    protected Screen parent;
    protected AudioDeviceList deviceList;
    protected Button back;
    protected int units;

    public SelectDeviceScreen(Component title, @Nullable Screen parent) {
        super(title, 236, 0);
        this.parent = parent;
    }

    public abstract List<String> getDevices();

    public abstract String getSelectedDevice();

    public abstract void onSelect(String var1);

    public abstract ResourceLocation getIcon(String var1);

    public abstract Component getEmptyListComponent();

    public abstract String getVisibleName(String var1);

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)2.2222223f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.deviceList != null) {
            this.deviceList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.deviceList = new AudioDeviceList(this.f_96543_, this.f_96544_, this.guiTop + 16, this.guiTop + 16 + this.units * 18, 36);
        }
        this.m_7787_((GuiEventListener)this.deviceList);
        this.back = Button.m_253074_((Component)BACK, button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.back);
        this.deviceList.m_5988_(this.getDevices().stream().map(s -> new AudioDeviceEntry(this, (String)s)).toList());
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
            for (int i = 0; i < this.units; ++i) {
                guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
            }
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
            guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.guiTop + 5, this.isIngame() ? 0x404040 : ChatFormatting.WHITE.m_126665_(), false);
        if (!this.deviceList.isEmpty()) {
            this.deviceList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else {
            Component component = this.getEmptyListComponent();
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280653_(this.f_96547_, component, n, n2 - 9 / 2, -1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (AudioDeviceEntry entry : this.deviceList.m_6702_()) {
            if (!entry.m_5953_(mouseX, mouseY) || this.getSelectedDevice().equals(entry.getDevice())) continue;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.onSelect(entry.getDevice());
            return true;
        }
        return false;
    }
}

