/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.audiodevice.SelectDeviceScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final ResourceLocation SELECTED = new ResourceLocation("voicechat", "textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = FastColor.ARGB32.m_13660_((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    protected final SelectDeviceScreen parent;

    public AudioDeviceEntry(SelectDeviceScreen parent, String device) {
        this.parent = parent;
        this.device = device;
        this.visibleDeviceName = parent.getVisibleName(device);
        this.minecraft = Minecraft.m_91087_();
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        boolean selected = this.parent.getSelectedDevice().equals(this.device);
        if (selected) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.m_280509_(left, top, left + width, top + height, BG_FILL);
        }
        guiGraphics.m_280163_(this.parent.getIcon(this.device), left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        if (selected) {
            guiGraphics.m_280163_(SELECTED, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        float deviceWidth = this.minecraft.f_91062_.m_92895_(this.visibleDeviceName);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        guiGraphics.m_280168_().m_85836_();
        PoseStack poseStack = guiGraphics.m_280168_();
        double d = left + 4 + 16 + 4;
        float f = top + height / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        poseStack.m_85837_(d, (double)(f - 9.0f * scale / 2.0f), 0.0);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(this.minecraft.f_91062_, this.visibleDeviceName, 0, 0, DEVICE_NAME_COLOR, false);
        guiGraphics.m_280168_().m_85849_();
    }

    public String getDevice() {
        return this.device;
    }
}

