/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.BitSet;
import mod.chiselsandbits.utils.BitUtils;

public class ByteArrayUtils {
    private ByteArrayUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ByteArrayUtils. This is a utility class");
    }

    public static BitSet fill(int value, int bitWidth, int count) {
        int valueMask = BitUtils.getBitMask(bitWidth);
        int totalBitCount = bitWidth * count;
        int byteCount = BitUtils.getByteCount(totalBitCount);
        BitSet result = new BitSet(totalBitCount);
        for (int insertionIndex = 0; insertionIndex < count; ++insertionIndex) {
            int bitOffset = insertionIndex * bitWidth;
            ByteArrayUtils.setValue(result, value, valueMask, bitOffset);
        }
        return result;
    }

    public static void setValueAt(BitSet target, int value, int bitWidth, int index) {
        ByteArrayUtils.setValue(target, value, BitUtils.getBitMask(bitWidth), index * bitWidth);
    }

    public static void setValueWith(BitSet target, int value, int bitMask, int index) {
        int maskWidth = BitUtils.getMaskWidth(bitMask);
        ByteArrayUtils.setValue(target, value, bitMask, index * maskWidth);
    }

    public static void setValue(BitSet target, int value, int bitMask, int bitOffset) {
        int maskWidth = BitUtils.getMaskWidth(bitMask);
        target.clear(bitOffset, bitOffset + maskWidth);
        for (int i = 0; i < maskWidth; ++i) {
            int inValueOffset = maskWidth - i - 1;
            boolean isSet = (value >> i & 1) != 0;
            target.set(bitOffset + i, isSet);
        }
    }

    public static int getValueAt(BitSet target, int bitWidth, int index) {
        return ByteArrayUtils.getValue(target, BitUtils.getBitMask(bitWidth), index * bitWidth);
    }

    public static int getValue(BitSet target, int bitMask, int bitOffset) {
        int maskWidth = BitUtils.getMaskWidth(bitMask);
        int result = 0;
        for (int i = 0; i < maskWidth; ++i) {
            boolean isSet = target.get(bitOffset + i);
            result |= (isSet ? 1 : 0) << i;
        }
        return result;
    }
}

