/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IAreaMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class MultiBlockMultiStateSnapshot
implements IMultiStateSnapshot {
    private Map<BlockPos, IMultiStateSnapshot> snapshots;
    private Vec3 startPoint;
    private Vec3 endPoint;

    public MultiBlockMultiStateSnapshot(Map<BlockPos, IMultiStateSnapshot> snapshots, Vec3 startPoint, Vec3 endPoint) {
        this.snapshots = snapshots;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        if (!BlockPosStreamProvider.getForRange(startPoint, endPoint).allMatch(snapshots::containsKey)) {
            throw new IllegalArgumentException("Not all required block positions are part of the given range.");
        }
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.snapshots.values());
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.snapshots.values().stream().flatMap(IAreaAccessor::stream);
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        BlockPos inAreaOffset = VectorUtils.toBlockPos(inAreaTarget);
        return this.isInside(inAreaOffset, inAreaTarget.m_82546_(Vec3.m_82528_((Vec3i)inAreaOffset)));
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        BlockPos targetPos = VectorUtils.toBlockPos(this.startPoint).m_121955_((Vec3i)inAreaBlockPosOffset);
        return this.snapshots.containsKey(targetPos) && this.snapshots.get(targetPos).isInside(BlockPos.f_121853_, inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        Map<BlockPos, IMultiStateSnapshot> copiedSnapshots = this.snapshots.keySet().stream().collect(Collectors.toMap(Function.identity(), pos -> this.snapshots.get(pos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(copiedSnapshots, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.startPoint.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.endPoint.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> Vec3.m_82528_((Vec3i)position).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            BlockPos blockPos = VectorUtils.toBlockPos(position);
            Vec3 inBlockOffset = position.m_82546_(Vec3.m_82528_((Vec3i)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(this.startPoint.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.endPoint.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), blockPos -> {
            Vec3i target = positionMutator.mutate((Vec3i)blockPos);
            Vec3 scaledTarget = Vec3.m_82528_((Vec3i)target).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            BlockPos blockTarget = VectorUtils.toBlockPos(scaledTarget);
            Vec3 inBlockOffset = scaledTarget.m_82546_(Vec3.m_82528_((Vec3i)blockPos));
            Optional<IStateEntryInfo> targetCandidate = this.getInBlockTarget((BlockPos)blockPos, inBlockOffset);
            targetCandidate.ifPresent(consumer);
        });
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        BlockPos inAreaOffset = VectorUtils.toBlockPos(inAreaTarget);
        return this.getInBlockTarget(inAreaOffset, inAreaTarget.m_82546_(Vec3.m_82528_((Vec3i)inAreaOffset)));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        BlockPos targetPos = VectorUtils.toBlockPos(this.startPoint).m_121955_((Vec3i)inAreaBlockPosOffset);
        if (!this.snapshots.containsKey(targetPos)) {
            throw new IllegalArgumentException("The given position is not in the current snapshot!");
        }
        return this.snapshots.get(targetPos).getInBlockTarget(BlockPos.f_121853_, inBlockTarget);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return this.snapshots.values().stream().flatMap(IAreaMutator::mutableStream);
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, Vec3 inAreaTarget) throws SpaceOccupiedException {
        Vec3 workingTarget = inAreaTarget.m_82549_(this.startPoint);
        BlockPos offset = VectorUtils.toBlockPos(workingTarget);
        Vec3 inBlockTarget = new Vec3(workingTarget.m_7096_() - (double)offset.m_123341_(), workingTarget.m_7098_() - (double)offset.m_123342_(), workingTarget.m_7094_() - (double)offset.m_123343_());
        this.setInBlockTarget(blockInformation, offset, inBlockTarget);
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        Vec3 workingTarget = Vec3.m_82528_((Vec3i)inAreaBlockPosOffset).m_82549_(inBlockTarget);
        if (workingTarget.m_7096_() < this.startPoint.m_7096_() || workingTarget.m_7098_() < this.startPoint.m_7098_() || workingTarget.m_7094_() < this.startPoint.m_7094_() || workingTarget.m_7096_() > this.endPoint.m_7096_() || workingTarget.m_7098_() > this.endPoint.m_7098_() || workingTarget.m_7094_() > this.endPoint.m_7094_()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        Vec3 workingTarget = inAreaTarget.m_82549_(this.startPoint);
        BlockPos offset = VectorUtils.toBlockPos(workingTarget);
        Vec3 inBlockTarget = new Vec3(workingTarget.m_7096_() - (double)offset.m_123341_(), workingTarget.m_7098_() - (double)offset.m_123342_(), workingTarget.m_7094_() - (double)offset.m_123343_());
        this.clearInBlockTarget(offset, inBlockTarget);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        Vec3 workingTarget = Vec3.m_82528_((Vec3i)inAreaBlockPosOffset).m_82549_(inBlockTarget);
        if (workingTarget.m_7096_() < this.startPoint.m_7096_() || workingTarget.m_7098_() < this.startPoint.m_7098_() || workingTarget.m_7094_() < this.startPoint.m_7094_() || workingTarget.m_7096_() > this.endPoint.m_7096_() || workingTarget.m_7098_() > this.endPoint.m_7098_() || workingTarget.m_7094_() > this.endPoint.m_7094_()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        throw new NotImplementedException("Multi block snapshots can not be contained in an itemstack as of now.");
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        return new IMultiStateObjectStatistics(){

            @Override
            public CompoundTag serializeNBT() {
                return new CompoundTag();
            }

            @Override
            public void deserializeNBT(CompoundTag nbt) {
            }

            @Override
            public IBlockInformation getPrimaryState() {
                return this.getStateCounts().entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
            }

            @Override
            public boolean isEmpty() {
                Map<IBlockInformation, Integer> stateMap = this.getStateCounts();
                return stateMap.size() == 1 && stateMap.getOrDefault(BlockInformation.AIR, 0) > 0;
            }

            @Override
            public Map<IBlockInformation, Integer> getStateCounts() {
                return MultiBlockMultiStateSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightBlockingFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(Player player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canSustainGrassBelow() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public BitSet getCollideableEntries(CollisionType collisionType) {
                return BitSet.valueOf(new long[0]);
            }
        };
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        Vec3 center = this.startPoint.m_82549_(this.endPoint).m_82542_(0.5, 0.5, 0.5);
        Map<BlockPos, IMultiStateSnapshot> rotatedParts = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            Vec3 offSetPos = Vec3.m_82528_((Vec3i)((Vec3i)e.getKey())).m_82546_(center);
            Vec3 rotatedOffset = VectorUtils.rotateMultipleTimes90Degrees(offSetPos, axis, rotationCount);
            return VectorUtils.toBlockPos(this.startPoint.m_82549_(rotatedOffset));
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.rotate(axis, rotationCount);
            return clone;
        }));
        Vec3 rotatedStartPoint = VectorUtils.rotateMultipleTimes90Degrees(this.startPoint.m_82546_(center), axis, rotationCount).m_82549_(center);
        Vec3 rotatedEndPoint = VectorUtils.rotateMultipleTimes90Degrees(this.endPoint.m_82546_(center), axis, rotationCount).m_82549_(center);
        Vec3 newStartPoint = VectorUtils.minimize(rotatedStartPoint, rotatedEndPoint);
        Vec3 newEndPoint = VectorUtils.maximize(rotatedStartPoint, rotatedEndPoint);
        this.snapshots = rotatedParts;
        this.startPoint = newStartPoint;
        this.endPoint = newEndPoint;
    }

    @Override
    public void mirror(Direction.Axis axis) {
        Vec3 center = this.startPoint.m_82549_(this.endPoint).m_82542_(0.5, 0.5, 0.5);
        this.snapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            int mirroredX = axis == Direction.Axis.X ? (int)(center.m_7096_() - (double)((BlockPos)e.getKey()).m_123341_()) : ((BlockPos)e.getKey()).m_123341_();
            int mirroredY = axis == Direction.Axis.Y ? (int)(center.m_7098_() - (double)((BlockPos)e.getKey()).m_123342_()) : ((BlockPos)e.getKey()).m_123342_();
            int mirroredZ = axis == Direction.Axis.Z ? (int)(center.m_7094_() - (double)((BlockPos)e.getKey()).m_123343_()) : ((BlockPos)e.getKey()).m_123343_();
            return new BlockPos(mirroredX, mirroredY, mirroredZ);
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.mirror(axis);
            return clone;
        }));
    }

    @Override
    public IMultiStateSnapshot clone() {
        Map<BlockPos, IMultiStateSnapshot> clonedSnapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IMultiStateSnapshot)e.getValue()).clone()));
        return new MultiBlockMultiStateSnapshot(clonedSnapshots, this.startPoint, this.endPoint);
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return new AABB(this.startPoint.m_7096_(), this.startPoint.m_7098_(), this.startPoint.m_7094_(), this.endPoint.m_7096_(), this.endPoint.m_7098_(), this.endPoint.m_7094_());
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;

        public Identifier(Collection<IMultiStateSnapshot> innerSnapshots) {
            this.inners = innerSnapshots.stream().map(IAreaAccessor::createNewShapeIdentifier).collect(Collectors.toList());
        }

        public int hashCode() {
            return Objects.hash(this.inners);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners);
        }
    }
}

