/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiMisc;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private PoseStack identityMatrixStack;
    private PoseStack identityMatrixStackOverlay;
    private Vector4f origin4f;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;
    private Waypoint previousClosest;
    private Waypoint workingClosest;
    private double workingClosestCos;
    private final WaypointDeleter waypointReachDeleter;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, WaypointDeleter waypointReachDeleter, Minecraft mc) {
        this.modMain = modMain;
        this.identityMatrixStack = new PoseStack();
        this.identityMatrixStackOverlay = new PoseStack();
        this.origin4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = w -> {
            WaypointFilterParams filterParams = this.filterParams;
            boolean deathpoints = filterParams.deathpoints;
            if (w.isDisabled() || w.getVisibilityType() == 2 || w.getVisibilityType() == 3 || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                return false;
            }
            double offX = (double)w.getX(filterParams.dimDiv) - filterParams.cameraX + 0.5;
            double offY = (double)w.getY() - filterParams.cameraY + 1.0;
            if (!w.isYIncluded()) {
                offY = filterParams.playerY - filterParams.cameraY + 1.0;
            }
            double offZ = (double)w.getZ(filterParams.dimDiv) - filterParams.cameraZ + 0.5;
            double depth = offX * (double)filterParams.lookVector.x() + offY * (double)filterParams.lookVector.y() + offZ * (double)filterParams.lookVector.z();
            if (depth <= 0.1) {
                return false;
            }
            double distanceScale = filterParams.dimensionScaleDistance ? Minecraft.m_91087_().f_91073_.m_6042_().f_63859_() : 1.0;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            double waypointsDistance = filterParams.waypointsDistance;
            double waypointsDistanceMin = filterParams.waypointsDistanceMin;
            return w.isOneoffDestination() || (w.getWaypointType() == 1 || w.isGlobal() || w.isTemporary() && filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
        };
        this.waypointReachDeleter = waypointReachDeleter;
    }

    public void render(XaeroMinimapSession minimapSession, float partial, MinimapProcessor minimap, Matrix4f waypointsProjection, Matrix4f worldModelView) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Vec3 cameraPos;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS) || mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            if (this.modMain.getSupportMods().vivecraft) {
                return;
            }
            Font fontrenderer = mc.f_91062_;
            if (fontrenderer == null) {
                return;
            }
            PoseStack matrixStack = this.identityMatrixStack;
            PoseStack matrixStackOverlay = this.identityMatrixStackOverlay;
            MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            String subworldName = null;
            if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
                subworldName = "(" + waypointsManager.getCurrentWorld().getContainer().getSubName() + ")";
            }
            Entity entity = mc.m_91288_();
            Camera activeRender = Minecraft.m_91087_().f_91063_.m_109153_();
            double actualEntityX = entity.m_20185_();
            double actualEntityY = entity.m_20186_();
            double actualEntityZ = entity.m_20189_();
            double smoothEntityY = minimap.getEntityRadar().getEntityY(entity, partial);
            Waypoint.RENDER_SORTING_POS = cameraPos = activeRender.m_90583_();
            double d3 = cameraPos.m_7096_();
            double d4 = cameraPos.m_7098_();
            double d5 = cameraPos.m_7094_();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.disableCull();
            matrixStack.m_85836_();
            matrixStack.m_85850_().m_252922_().mul((Matrix4fc)worldModelView);
            Lighting.m_84930_();
            double fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).doubleValue();
            int screenWidth = Minecraft.m_91087_().m_91268_().m_85441_();
            int screenHeight = Minecraft.m_91087_().m_91268_().m_85442_();
            float cameraAngleYaw = activeRender.m_90590_();
            float cameraAnglePitch = activeRender.m_90589_();
            Vector3f lookVector = activeRender.m_253058_().get(new Vector3f());
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            List<Waypoint> sortingList = this.sortingList;
            sortingList.clear();
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        sortingList.addAll(setEntry.getValue().getList());
                    }
                } else {
                    sortingList.addAll(waypointsManager.getWaypoints().getList());
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    sortingList.addAll(modCustomWaypoints.values());
                }
            }
            matrixStackOverlay.m_85836_();
            matrixStackOverlay.m_252880_(0.0f, 0.0f, -2980.0f);
            if (!sortingList.isEmpty()) {
                this.waypointReachDeleter.begin();
                ModSettings settings = this.modMain.getSettings();
                this.filterParams.setParams(d3, d4, d5, lookVector, dimDiv, settings.getDeathpoints(), settings.temporaryWaypointsGlobal, settings.getMaxWaypointsDistance(), settings.waypointsDistanceMin, smoothEntityY, settings.dimensionScaledMaxWaypointDistance);
                Stream<Waypoint> waypointStream = sortingList.stream().filter(this.filter).sorted();
                MultiBufferSource.BufferSource cvcRenderTypeBuffer = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                VertexConsumer waypointBackgroundConsumer = cvcRenderTypeBuffer.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
                double minDistance = settings.waypointsDistanceMin;
                this.renderWaypointsIterator(matrixStack, matrixStackOverlay, helper, waypointStream.iterator(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, cvcRenderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, false, minDistance, subworldName);
                this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), settings.renderAllSets);
            }
            matrixStackOverlay.m_85849_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            Lighting.m_84931_();
            matrixStack.m_85849_();
        }
    }

    private void renderWaypointsIterator(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, Iterator<Waypoint> iter, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tesselator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, double clampDepth, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Font fontrenderer, Matrix4f waypointsProjection, int screenWidth, boolean detailedDisplayAllowed, double minDistance, String subworldName) {
        boolean onlyMainInfo;
        int count = 0;
        this.workingClosest = null;
        int displayMultipleWaypointInfo = this.modMain.getSettings().displayMultipleWaypointInfo;
        boolean deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        boolean bl = onlyMainInfo = displayMultipleWaypointInfo == 0 || displayMultipleWaypointInfo == 1 && !entity.m_6144_();
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            this.renderWaypointIngame(matrixStack, matrixStackOverlay, helper, cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, renderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, screenHeight, false, onlyMainInfo, minDistance, deleteReachedDeathpoints, subworldName);
            if (++count >= 19500) continue;
            matrixStackOverlay.m_252880_(0.0f, 0.0f, 0.1f);
        }
        if (onlyMainInfo && this.previousClosest != null) {
            this.renderWaypointIngame(matrixStack, matrixStackOverlay, helper, cameraAngleYaw, cameraAnglePitch, lookVector, this.previousClosest, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, renderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, screenHeight, true, onlyMainInfo, minDistance, false, subworldName);
        }
        this.previousClosest = this.workingClosest;
        renderTypeBuffer.m_109911_();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
    }

    private void renderWaypointIngame(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tesselator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Font fontrenderer, Matrix4f waypointsProjection, int screenWidth, int screenHeight, boolean isTheMain, boolean onlyMainInfo, double minDistance, boolean deleteReachedDeathpoints, String subworldName) {
        int wX = w.getX(dimDiv);
        int wZ = w.getZ(dimDiv);
        double offX = (double)wX - d3 + 0.5;
        double offY = (double)w.getY() - d4 + 1.0;
        if (!w.isYIncluded()) {
            offY = smoothEntityY - d4 + 1.0;
        }
        double offZ = (double)wZ - d5 + 0.5;
        double depth = offX * (double)lookVector.x() + offY * (double)lookVector.y() + offZ * (double)lookVector.z();
        double correctOffX = actualEntityX - (double)wX - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        if (!w.isYIncluded()) {
            correctOffY = 0.0;
        }
        double correctOffZ = actualEntityZ - (double)wZ - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if ((deleteReachedDeathpoints || w.getWaypointType() != 1 && w.getWaypointType() != 2) && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L && correctDistance < 4.0) {
            this.waypointReachDeleter.add(w);
        }
        if (minDistance != 0.0 && distance2D < minDistance) {
            return;
        }
        double originalOffY = offY;
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        Object distanceText = "";
        boolean couldShowDistance = false;
        boolean showDistance = false;
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0 ? 0.001 : offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / (double)Z));
                if (offZ < 0.0) {
                    angle = offX < 0.0 ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = couldShowDistance = Math.abs(offset = Mth.m_14177_((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan(-originalOffY / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    couldShowDistance = couldShowDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                couldShowDistance = true;
            }
            if (couldShowDistance) {
                if (!isTheMain) {
                    double cos = depth / distance;
                    if (this.workingClosest == null || cos > this.workingClosestCos) {
                        this.workingClosest = w;
                        this.workingClosestCos = cos;
                    }
                    if (!onlyMainInfo) {
                        showDistance = true;
                    }
                } else {
                    showDistance = true;
                }
            }
            if (showDistance) {
                int autoConvertWaypointDistanceToKmThreshold = modMain.getSettings().autoConvertWaypointDistanceToKmThreshold;
                distanceText = autoConvertWaypointDistanceToKmThreshold != -1 && correctDistance >= (double)autoConvertWaypointDistanceToKmThreshold ? GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance / 1000.0) + "km" : GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        if (onlyMainInfo && this.previousClosest == w && !isTheMain) {
            return;
        }
        matrixStack.m_85836_();
        matrixStackOverlay.m_85836_();
        if (distance > 250000.0) {
            double offScaler = 250000.0 / distance;
            offX *= offScaler;
            offY *= offScaler;
            offZ *= offScaler;
        }
        matrixStack.m_85837_(offX, offY, offZ);
        this.drawAsOverlay(matrixStack, matrixStackOverlay, helper, w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, (String)distanceText, textSize, showDistance, textRenderTypeBuffer, waypointBackgroundConsumer, waypointsProjection, screenWidth, screenHeight, depthClamp, depth, isTheMain, subworldName);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
        matrixStackOverlay.m_85849_();
    }

    public void drawAsOverlay(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tesselator tessellator, Font fontrenderer, String name, String distance, float textSize, boolean showDistance, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Matrix4f waypointsProjection, int screenWidth, int screenHeight, double depthClamp, double depth, boolean isTheMain, String subworldName) {
        this.origin4f.mul((Matrix4fc)matrixStack.m_85850_().m_252922_());
        this.origin4f.mul((Matrix4fc)waypointsProjection);
        int overlayPosX = (int)((1.0f + this.origin4f.x() / this.origin4f.w()) / 2.0f * (float)screenWidth);
        int overlayPosY = (int)((1.0f - this.origin4f.y() / this.origin4f.w()) / 2.0f * (float)screenHeight);
        this.origin4f.set(0.0f, 0.0f, 0.0f, 1.0f);
        matrixStackOverlay.m_252880_((float)overlayPosX, (float)overlayPosY, 0.0f);
        if (depth < depthClamp) {
            float scale = (float)(depthClamp / depth);
            matrixStackOverlay.m_85841_(scale, scale, scale);
        }
        this.drawIconInWorld(matrixStackOverlay, helper, w, settings, vertexBuffer, tessellator, fontrenderer, name, distance, textSize, showDistance, renderTypeBuffer, waypointBackgroundConsumer, isTheMain, subworldName);
    }

    public void drawIconInWorld(PoseStack matrixStack, MinimapRendererHelper helper, Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tesselator tessellator, Font fontrenderer, String name, String distance, float textSize, boolean showDistance, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, boolean isTheMain, String subworldName) {
        double iconScale = settings.getWaypointsIngameIconScale();
        double distanceScale = settings.getWaypointsIngameDistanceScale();
        double nameScale = settings.getWaypointsIngameNameScale();
        int ingameOpacity = settings.waypointOpacityIngame;
        int addedFrame = 0;
        if (Minecraft.m_91087_().m_91390_()) {
            iconScale = (int)((iconScale + 1.0) / 2.0) * 2;
            distanceScale = (int)((distanceScale + 1.0) / 2.0) * 2;
            nameScale = (int)((nameScale + 1.0) / 2.0) * 2;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float red = (float)(c >> 16 & 0xFF) / 255.0f;
        float green = (float)(c >> 8 & 0xFF) / 255.0f;
        float blue = (float)(c & 0xFF) / 255.0f;
        float alpha = 133.3f * ((float)ingameOpacity / 100.0f) / 255.0f;
        if (isTheMain) {
            alpha = Math.min(1.0f, alpha * 1.5f);
        }
        int halfIconPixel = (int)iconScale / 2;
        matrixStack.m_252880_((float)halfIconPixel, 0.0f, 0.0f);
        matrixStack.m_85841_((float)iconScale, (float)iconScale, 1.0f);
        if (w.getWaypointType() != 1) {
            int initialsWidth = fontrenderer.m_92895_(w.getSymbol());
            addedFrame = WaypointUtil.getAddedMinimapIconFrame(addedFrame, initialsWidth);
            this.renderColorBackground(matrixStack, addedFrame, red, green, blue, alpha, waypointBackgroundConsumer);
            Misc.drawNormalText(matrixStack, w.getSymbol(), (float)(-initialsWidth / 2), -8.0f, -1, false, renderTypeBuffer);
        } else {
            addedFrame = WaypointUtil.getAddedMinimapIconFrame(addedFrame, 7);
            this.renderColorBackground(matrixStack, addedFrame, red, green, blue, alpha, waypointBackgroundConsumer);
            VertexConsumer guiNearestConsumer = renderTypeBuffer.m_6299_(CustomRenderTypes.GUI_NEAREST);
            this.renderTexturedIcon(matrixStack, addedFrame, 0, 78, 0.9882f, 0.9882f, 0.9882f, 1.0f, guiNearestConsumer);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        matrixStack.m_85841_((float)(1.0 / iconScale), (float)(1.0 / iconScale), 1.0f);
        matrixStack.m_252880_((float)(-halfIconPixel), 0.0f, 0.0f);
        matrixStack.m_252880_(0.0f, 2.0f, 0.0f);
        float labelAlpha = 0.3529412f;
        if ((showDistance || showingName) && subworldName != null) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, subworldName, nameScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
            matrixStack.m_252880_(0.0f, 2.0f, 0.0f);
        }
        if (showingName) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, name, nameScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
        matrixStack.m_252880_(0.0f, 2.0f, 0.0f);
        if (distance.length() > 0) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, distance, distanceScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
    }

    private void renderWaypointLabel(PoseStack matrixStack, MinimapRendererHelper helper, Font fontrenderer, String label, double labelScale, float bgAlpha, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        int nameW = fontrenderer.m_92895_(label);
        int bgW = nameW + 3;
        int halfBgW = bgW / 2;
        int halfNamePixel = 0;
        if ((bgW & 1) != 0) {
            halfNamePixel = (int)labelScale - (int)labelScale / 2;
            matrixStack.m_252880_((float)(-halfNamePixel), 0.0f, 0.0f);
        }
        matrixStack.m_85841_((float)labelScale, (float)labelScale, 1.0f);
        helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), waypointBackgroundConsumer, -halfBgW, 0.0f, bgW, 9, 0.0f, 0.0f, 0.0f, bgAlpha);
        Misc.drawNormalText(matrixStack, label, (float)(-halfBgW + 2), 1.0f, -1, false, renderTypeBuffer);
        matrixStack.m_252880_(0.0f, 9.0f, 0.0f);
        matrixStack.m_85841_((float)(1.0 / labelScale), (float)(1.0 / labelScale), 1.0f);
        if ((bgW & 1) != 0) {
            matrixStack.m_252880_((float)halfNamePixel, 0.0f, 0.0f);
        }
        RenderSystem.enableBlend();
    }

    private void renderColorBackground(PoseStack matrixStack, int addedFrame, float r, float g, float b, float a, VertexConsumer waypointBackgroundConsumer) {
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        waypointBackgroundConsumer.m_252986_(matrix, (float)(-5 - addedFrame), -9.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        waypointBackgroundConsumer.m_252986_(matrix, (float)(-5 - addedFrame), 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        waypointBackgroundConsumer.m_252986_(matrix, (float)(4 + addedFrame), 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        waypointBackgroundConsumer.m_252986_(matrix, (float)(4 + addedFrame), -9.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    private void renderTexturedIcon(PoseStack matrixStack, int addedFrame, int textureX, int textureY, float r, float g, float b, float a, VertexConsumer vertexBuffer) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        vertexBuffer.m_252986_(matrix, (float)(-5 - addedFrame), (float)(-9 - addedFrame), 0.0f).m_85950_(r, g, b, a).m_7421_((float)textureX * f, (float)textureY * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, (float)(-5 - addedFrame), (float)addedFrame, 0.0f).m_85950_(r, g, b, a).m_7421_((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, (float)(4 + addedFrame), (float)addedFrame, 0.0f).m_85950_(r, g, b, a).m_7421_((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, (float)(4 + addedFrame), (float)(-9 - addedFrame), 0.0f).m_85950_(r, g, b, a).m_7421_((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1).m_5752_();
    }
}

