/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.resource.ShaderResourceReloadListener;

public class ModEvents {
    private IXaeroMinimap modMain;

    public ModEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        InterfaceManager interfaceManager;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            minimapSession.getMinimapProcessor().getMinimapWriter().setClearBlockColours(true);
            minimapSession.getMinimapProcessor().getMinimapWriter().resetShortBlocks();
        }
        if ((interfaceManager = this.modMain.getInterfaces()) != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        InterfaceManager interfaceManager = this.modMain.getInterfaces();
        if (interfaceManager != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    @SubscribeEvent
    public void handleRegisterClientResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ShaderResourceReloadListener());
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.modMain.createControlsRegister();
        this.modMain.getControlsRegister().registerKeybindings(event);
    }

    @SubscribeEvent
    public void registerOverlay(RegisterGuiOverlaysEvent event) {
        InterfaceRenderer.registerOverlay(event);
    }
}

