/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.core.IXaeroMinimapSMultiBlockChangePacket;
import xaero.common.interfaces.pushbox.IBossHealthPushBox;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.misc.Misc;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;
    private static Matrix4f waypointsProjection;
    private static Matrix4f waypointModelView;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = LevelChunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        LevelChunk chunk = world.m_6325_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(int x, int z, ClientboundLevelChunkPacketData packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(x, z);
    }

    public static void onChunkLightData(int x, int z) {
        XaeroMinimapCore.chunkUpdateCallback(x, z);
    }

    public static void onHandleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet) {
        XaeroMinimapCore.onChunkLightData(packet.m_195717_(), packet.m_195718_());
    }

    public static void onHandleLightUpdatePacket(ClientboundLightUpdatePacket packet) {
        XaeroMinimapCore.onChunkLightData(packet.m_132349_(), packet.m_132352_());
    }

    public static void onQueueLightRemoval(ClientboundForgetLevelChunkPacket packet) {
        XaeroMinimapCore.onChunkLightData(packet.m_132149_(), packet.m_132152_());
    }

    public static void onBlockChange(ClientboundBlockUpdatePacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.m_131749_().m_123341_() >> 4, packetIn.m_131749_().m_123343_() >> 4);
    }

    public static void onMultiBlockChange(ClientboundSectionBlocksUpdatePacket packetIn) {
        IXaeroMinimapSMultiBlockChangePacket packetAccess = (IXaeroMinimapSMultiBlockChangePacket)packetIn;
        XaeroMinimapCore.chunkUpdateCallback(packetAccess.xaero_mm_getSectionPos().m_123341_(), packetAccess.xaero_mm_getSectionPos().m_123343_());
    }

    public static void onSpawn(ClientboundSetDefaultSpawnPositionPacket packetIn) {
        modMain.getEvents().handlePlayerSetSpawn((Level)Minecraft.m_91087_().f_91073_, packetIn.m_133123_());
    }

    public static void onPlayNetHandler(ClientPacketListener netHandler, ClientboundLoginPacket packet) {
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                MinimapLogs.LOGGER.info("Previous minimap session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init(netHandler);
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            MinimapLogs.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPacketListener netHandler) {
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(Player player) {
        if (player == Minecraft.m_91087_().f_91074_) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().createDeathpoint(player);
        }
    }

    public static void onProjectionMatrix(Matrix4f matrixIn) {
        waypointsProjection.set((Matrix4fc)matrixIn);
    }

    public static void onWorldModelViewMatrix(PoseStack matrixStack) {
        waypointModelView.set((Matrix4fc)matrixStack.m_85850_().m_252922_());
    }

    public static void beforeIngameGuiRender(float partialTicks) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            Window mainwindow = Minecraft.m_91087_().m_91268_();
            Matrix4f projectionMatrixBU = RenderSystem.getProjectionMatrix();
            VertexSorting vertexSortingBU = RenderSystem.getVertexSorting();
            Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)mainwindow.m_85441_(), (float)mainwindow.m_85442_(), 0.0f, 1000.0f, 3000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.f_276633_);
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            RenderSystem.applyModelViewMatrix();
            modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks, minimapSession.getMinimapProcessor(), waypointsProjection, waypointModelView);
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrixBU, (VertexSorting)vertexSortingBU);
        }
    }

    public static void onBossHealthRender(int h) {
        IBossHealthPushBox bossHealthPushBox = modMain.getInterfaces().getBossHealthPushBox();
        if (bossHealthPushBox != null) {
            bossHealthPushBox.setActive(true);
            bossHealthPushBox.setLastBossHealthHeight(h);
        }
    }

    public static void onEntityIconsModelRenderDetection(EntityModel<?> model, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public static void onEntityIconsModelPartRenderDetection(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    public static void onDeleteWorld(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
        Path worldMinimapDataFolder;
        Path worldName = levelStorageAccess.getWorldDir().getFileName();
        if (!worldName.toString().isEmpty() && (worldMinimapDataFolder = modMain.getWaypointsFolder().toPath().resolve(worldName)).toFile().exists()) {
            try {
                Misc.deleteFile(worldMinimapDataFolder, 20);
                MinimapLogs.LOGGER.info(String.format("Deleted minimap world data at %s", worldMinimapDataFolder));
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error(String.format("Failed to delete minimap world data at %s!", worldMinimapDataFolder), (Throwable)e);
            }
        }
    }

    public static boolean onLocalPlayerCommand(String command) {
        return modMain.getEvents().handleClientSendChat(command);
    }

    public static boolean onSystemChat(Component component) {
        return modMain.getEvents().handleClientSystemChatReceivedEvent(component);
    }

    public static boolean onHandleDisguisedChatMessage(ChatType.Bound chatType, Component component) {
        return !modMain.getEvents().handleClientPlayerChatReceivedEvent(chatType, component, null);
    }

    static {
        chunkCleanField = null;
        waypointsProjection = new Matrix4f();
        waypointModelView = new Matrix4f();
    }
}

