/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.ClientUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    private static final GuiGraphics GUI_GRAPHICS = new GuiGraphics(null, null);
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fontRenderer.m_272077_(text, x, y, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawString(poseStack, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fontRenderer.m_272077_(text, x, y, color, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fontRenderer.m_271703_(text, x, y, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        fontRenderer.m_271703_(text, x, y, color, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, fontRenderer, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, fontRenderer, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, fontRenderer, text, x, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(PoseStack poseStack, float x, float y, float width, float height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        ScreenUtils.bindTexture(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(PoseStack poseStack, float x, float y, float width, float height, float yOffset) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        ScreenUtils.bindTexture(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height) {
        ScreenUtils.drawTexture(poseStack, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + height, 0.0f).m_7421_(tx, ty + theight).m_5752_();
        buffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(tx + twidth, ty + theight).m_5752_();
        buffer.m_252986_(matrix, x + width, y, 0.0f).m_7421_(tx + twidth, ty).m_5752_();
        buffer.m_252986_(matrix, x, y, 0.0f).m_7421_(tx, ty).m_5752_();
        tessellator.m_85914_();
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(poseStack, x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, x, y + height, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x + width, y + height, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x + width, y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_252986_(matrix, x, y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltipInternal(poseStack, fontRenderer, text.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, Collections.singletonList(text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, (Component)Component.m_237113_((String)text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    private static void drawTooltipInternal(PoseStack poseStack, Font fontRenderer, List<ClientTooltipComponent> components, int x, int y) {
        if (components.isEmpty()) {
            return;
        }
        ScreenUtils.GUI_GRAPHICS.f_279544_ = ClientUtils.getMinecraft();
        ScreenUtils.GUI_GRAPHICS.f_279612_ = poseStack;
        ScreenUtils.GUI_GRAPHICS.f_279627_ = ClientUtils.getMinecraft().f_91063_.f_109064_.m_110104_();
        GUI_GRAPHICS.m_280497_(fontRenderer, components, x, y, DefaultTooltipPositioner.f_262752_);
        ScreenUtils.GUI_GRAPHICS.f_279627_.m_109911_();
    }

    public static void drawItem(PoseStack poseStack, ItemStack stack, @Nullable Level level, int x, int y) {
        if (stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        try {
            boolean useFlatLighting;
            BakedModel model = ClientUtils.getItemRenderer().m_174264_(stack, level, null, 0);
            boolean bl = useFlatLighting = !model.m_7547_();
            if (useFlatLighting) {
                Lighting.m_84930_();
            }
            RenderSystem.disableDepthTest();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            ClientUtils.getItemRenderer().m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (useFlatLighting) {
                Lighting.m_84931_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being rendered");
            crashReportCategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashReportCategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
            crashReportCategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashReportCategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashReport);
        }
        poseStack.m_85849_();
    }
}

